/*



 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <jpeglib.h>
#include <time.h>
#include <linux/videodev2.h>

#include <sys/socket.h>
#include <errno.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/sendfile.h>

#include "v4l2uvc.h"

#define MSG_SIZE 40			// message size

int run = 1;


#define PORT_NUMBER     2001
#define SERVER_ADDRESS  "10.3.52.19"
#define FILE_TO_SEND    "snap000.ppm"


void sigcatch (int sig)
{
  fprintf (stderr, "Exiting...\n");
  run = 0;
}

void WritePPM( const char* filename , unsigned char* target, int cols, int rows ) {
    //Write the img
    char           frmHeader[32], temp;
    FILE*          imgfile;
    int            i;

    memset(frmHeader, 0, 32);
    sprintf(frmHeader, "P6\n%u %u\n255\n", cols, rows);
    imgfile=fopen(filename, "wb");
    if(imgfile==NULL) exit(0);
    fwrite(frmHeader, 1, strlen(frmHeader), imgfile);
    //for (i=0; i<=(rows*cols); i++) {
       //temp          = target[3*i];
       //target[3*i]   = target[3*i+2];
       //target[3*i+2] = temp; }
    fwrite(target, 1, cols*rows*3, imgfile);
    fclose(imgfile); }


int yuyv_to_rgb (struct vdIn *vd, unsigned char *buffer_ptr)
{
  unsigned char *yuyv;
  int i,z, x;
  int r, g, b;
  int y, u, v;

  yuyv = vd->framebuffer;

  z = 0;
  for (i = 0; i < vd->height; i++) {
    for (x = 0; x < vd->width; x++) {
      if (!z)
      y = yuyv[0] << 8;
      else
      y = yuyv[2] << 8;
      u = yuyv[1] - 128;
      v = yuyv[3] - 128;

      r = (y + (359 * v)) >> 8;
      g = (y - (88 * u) - (183 * v)) >> 8;
      b = (y + (454 * u)) >> 8;

      *(buffer_ptr++) = (r > 255) ? 255 : ((r < 0) ? 0 : r);
      *(buffer_ptr++) = (g > 255) ? 255 : ((g < 0) ? 0 : g);
      *(buffer_ptr++) = (b > 255) ? 255 : ((b < 0) ? 0 : b);

      if (z++) {
         z = 0;
         yuyv += 4; } } }

  return (0);
   }

int main (int argc, char *argv[]) {



   char        *videodevice = "/dev/video0";
  char         outputfile[100];
  int          format = V4L2_PIX_FMT_MJPEG;
  int          grabmethod = 1;    // 1 = mmap   0 = read
//int          width = 1280;
//int          height = 720;
  int          width = 640;
  int          height = 480;
//int          width = 352;
//int          height = 288;
  int          brightness = 120, contrast = 0, saturation = 30, gain = 0;
  time_t       ref_time;
  struct vdIn *videoIn;
  int          count=0;



// set up info to talk to main server
  int server_socket;
          int peer_socket;
          socklen_t       sock_len;
          ssize_t len;
          struct sockaddr_in      server_addr;
          struct sockaddr_in      peer_addr;
          int fd;
          int sent_bytes = 0;
          char file_size[256];
          struct stat file_stat;
          int offset;
          int remain_data;

          /* Create server socket */
          server_socket = socket(AF_INET, SOCK_STREAM, 0);
          if (server_socket == -1)
          {
                  fprintf(stderr, "Error creating socket --> %s", strerror(errno));

                  exit(EXIT_FAILURE);
          }

          /* Zeroing server_addr struct */
          memset(&server_addr, 0, sizeof(server_addr));
          portno = atoi(argv[1]);	// get port number from input
          /* Construct server_addr struct */
          server_addr.sin_family = AF_INET;
          inet_pton(AF_INET, SERVER_ADDRESS, &(server_addr.sin_addr));
          server_addr.sin_port = htons(portno);

          // Bind
          if ((bind(server_socket, (struct sockaddr *)&server_addr, sizeof(struct sockaddr))) == -1)
          {
                  fprintf(stderr, "Error on bind --> %s", strerror(errno));

                  exit(EXIT_FAILURE);
          }

        listen(server_socket, 5);
        sock_len = sizeof(struct sockaddr_in);

    // wait here for server to connect to pi

        peer_socket = accept(server_socket, (struct sockaddr *)&peer_addr, &sock_len);
        if (peer_socket == -1)
        {
            fprintf(stderr, "Error on accept --> %s", strerror(errno));

            exit(EXIT_FAILURE);
        }

   		int n;
   		char buffer[MSG_SIZE];

while (1) // loop waiting for request, take photo send it out.
{
   		bzero(buffer,MSG_SIZE);
   		n = read(peer_socket,buffer,MSG_SIZE-1);
   		if (n < 0)
	   		error("ERROR reading from socket");
   	

   
		if ( buffer[0] == '1')// request made fro pic.
		{
   
            (void) signal (SIGINT, sigcatch);
              (void) signal (SIGQUIT, sigcatch);
              (void) signal (SIGKILL, sigcatch);
              (void) signal (SIGTERM, sigcatch);
              (void) signal (SIGABRT, sigcatch);
              (void) signal (SIGTRAP, sigcatch);

              //if ((width > 960) || (height > 720))
                format = V4L2_PIX_FMT_YUYV;
                //format = V4L2_PIX_FMT_RGB24;

              videoIn = (struct vdIn *) calloc (1, sizeof (struct vdIn));
              if (init_videoIn(videoIn, (char *) videodevice, width, height, format, grabmethod) < 0)
                exit (1);

              unsigned char *rgbbuffer = malloc(videoIn->width * videoIn->height * 3);
              //Reset all camera controls
              v4l2ResetControl (videoIn, V4L2_CID_BRIGHTNESS);
              v4l2ResetControl (videoIn, V4L2_CID_CONTRAST);
              v4l2ResetControl (videoIn, V4L2_CID_SATURATION);
              v4l2ResetControl (videoIn, V4L2_CID_GAIN);

              //Setup Camera Parameters
              if (brightness != 0) {
                //fprintf (stderr, "Camera brightness level is %d\n", v4l2GetControl (videoIn, V4L2_CID_BRIGHTNESS));
                v4l2SetControl (videoIn, V4L2_CID_BRIGHTNESS, brightness); }
              if (contrast != 0) {
                //fprintf (stderr, "Camera contrast level is %d\n", v4l2GetControl (videoIn, V4L2_CID_CONTRAST));
                v4l2SetControl (videoIn, V4L2_CID_CONTRAST, contrast); }
              if (saturation != 0) {
                //fprintf (stderr, "Camera saturation level is %d\n", v4l2GetControl (videoIn, V4L2_CID_SATURATION));
                v4l2SetControl (videoIn, V4L2_CID_SATURATION, saturation); }
              if (gain != 0) {
                //fprintf (stderr, "Camera gain level is %d\n", v4l2GetControl (videoIn, V4L2_CID_GAIN));
                v4l2SetControl (videoIn, V4L2_CID_GAIN, gain); }

              ref_time = time (NULL);

                sprintf(outputfile, "snap%03d.ppm", count++);
                if (uvcGrab (videoIn) < 0)
                {
                  fprintf (stderr, "Error grabbing\n");
                  close_v4l2 (videoIn);
                  free (videoIn);
                  exit (1);
                }

                switch (videoIn->formatIn)
                {
                   case V4L2_PIX_FMT_YUYV:
                     yuyv_to_rgb (videoIn, rgbbuffer);
                     WritePPM(outputfile, rgbbuffer, videoIn->width, videoIn->height);
                     break;
                   default:
                     WritePPM(outputfile, videoIn->tmpbuffer, videoIn->width, videoIn->height);
                     //fwrite (videoIn->tmpbuffer, videoIn->buf.bytesused + DHT_SIZE, 1, file);
                     break;
                }
                videoIn->getPict = 0;


            	close_v4l2 (videoIn);
             	 free (videoIn);//

				fd = open(FILE_TO_SEND, O_RDONLY);
                     if (fd == -1)
                     {
                             fprintf(stderr, "Error opening file --> %s", strerror(errno));

                             exit(EXIT_FAILURE);
                     }

                     // Get file stats
                     if (fstat(fd, &file_stat) < 0)
                     {
                             fprintf(stderr, "Error fstat --> %s", strerror(errno));

                             exit(EXIT_FAILURE);
                     }

                     sprintf(file_size, "%d", file_stat.st_size);
                   
                     // Sending file size so the it knows how long to get pic
                     len = send(peer_socket, file_size, sizeof(file_size), 0);
                     if (len < 0)
                     {
                           fprintf(stderr, "Error on sending greetings --> %s", strerror(errno));

                           exit(EXIT_FAILURE);
                     }

                     offset = 0;
                     remain_data = file_stat.st_size;
                     // Sending file data
                     while (((sent_bytes = sendfile(peer_socket, fd, NULL, BUFSIZ)) > 0) && (remain_data > 0))
                     {
                             remain_data -= sent_bytes;
                  
                     }

        }
       
}

          close(peer_socket);
          close(server_socket);

  return 0;
}


